/* <nagd02.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library d02 Chapter
 *
 * Mark 4, revised, 1996.
 * Mark 5 revised. IER-2145 (Feb 1998).
 * Mark 6 revised. IER-3027 (July 2000).
 */
#ifndef NAGD02
#define NAGD02

/// ML 9/22/2004 COMPILING_ONAG8HEADERS_IN_OC
#ifndef _MSC_VER	   //VC
	// This must be put into every header since it does not appear to be
	// inheritable from parent header to child (#include-ded) header:
	#pragma dll(ONAG8)
#endif // !_MSC_VER	   //VC
/// end COMPILING_ONAG8HEADERS_IN_OC

#ifdef __cplusplus
extern "C"
{
#endif
  /* Note :
   * d02qfg is called only by d02qfv.
   * A subsection of the original d02qfv was placed in
   * this external function to allow compilation on PC's.
   */
  /* begin proto */
  extern NAG_DLL_EXPIMP void NAG_CALL d02cjc(Integer neq, 
                                             NAG_D02CJC_FUN fcn,
                                             double *t, double y[], double tend,
                                             double tol, Nag_ErrorControl err_c,
                                             NAG_D02CJC_OUTFUN output,
                                             NAG_D02CJC_GFUN g,
                                             Nag_User *comm, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL d02ejc(Integer neq, NAG_D02EJC_FUN fcn,
                                             NAG_D02EJC_PFUN pederv,
                                             double *t, double y[], double tend, 
                                             double tol, Nag_ErrorControl err_c,
                                             NAG_D02EJC_OUTFUN output, NAG_D02EJC_GFUN g,
                                             Nag_User *comm, NagError *fail);
  extern void d02eju(double *xout, NAG_D02EJC_OUTFUN output,
                     double chk[], Integer n, 
                     double *ysav, double acor[], double *x, Integer *nqu, double *hu,
                     double *h, Integer *iflag, double *xlast, double *xnew, 
                     double dir, Nag_User *comm, Nag_ODE_BDF *intern_comm);
  extern void d02ejv(Integer n,double *x, double y[], double *hu, double *xlast, 
                     double *h, double *rnqu, double ysav[], double acor[],
                     double chk[], Integer *imon, Integer *nstps, double *glast,
                     NAG_D02EJC_GFUN g,
                     Integer *iflag, double d[], Integer *ifin, double dir, 
                     double *root, NAG_D02EJC_OUTFUN output, 
                     Integer *path, double *xout, 
                     Nag_User *comm, Nag_ODE_BDF *intern_comm);
  extern NAG_DLL_EXPIMP void NAG_CALL d02gac(Integer neq, 
                                             NAG_D02GAC_FUN fcn,
                                             double a, double b, double u[], Integer v[],
                                             Integer mnp, Integer *np, double x[], double y[],
                                             double tol, Nag_User *comm, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL d02gbc(Integer neq, 
                                             NAG_D02GBC_FUN fcnf,
                                             NAG_D02GBC_GFUN fcng,
                                             double a, double b, double c[], double d[], double gam[],
                                             Integer mnp, Integer *np, double x[], double y[], double tol,
                                             Nag_User *comm, NagError *fail);
  extern void d02gbz(double e[], double f[], Integer n, double c[],
                     double d[], Integer * ind, double w[]);
  extern NAG_DLL_EXPIMP void NAG_CALL d02nmc(Integer neq, Integer neqmax, double *t, double tout, double y[],
                                             double ydoti[], double rwork[], double rtol[], 
                                             double a_tol[], Integer itol, Integer inform[], double ysave[], 
                                             Integer ny2dim, double wkjac[], Integer nwkjac, Integer jacpvt[],
                                             Integer njcpvt, Integer *imon, Integer *inln, Integer *ires, 
                                             Integer *irevcm, Integer itask, Integer jtrace, Integer *ifail,
                                             Nag_ODE_BDF *intern_comm);
  extern void d02nmq(double wm[], Integer iwm[], double x[], Integer n, Integer *ier,
                     Nag_ODE_BDF *intern_comm);
  extern void d02nmt(double a[], Integer lda, Integer n, double rdae[], 
                     double h, double el0);
  extern void d02nmu(Integer neq, double y[], double *yh, Integer nyh, double ewt[], 
                     double rtem[], double savr[], double *ydot, double wm[], 
                     Integer *iwm, Integer *ifj, double h, double el0, double *tn, 
                     Integer *ifunc, double rdae[], double rworkx[], Integer *irevcm,
                     Integer inform[], Nag_ODE_BDF *intern_comm);
  extern void d02nmv(Integer n, double y[], double ydoti[], double yh[], Integer nyh,
                     double savr[], double acor[], double ewt[], Integer *ifunc, 
                     Integer *inln, double *h, double *el0, double rdae[],
                     Nag_ODE_BDF *intern_comm);
  extern void d02nmw(Integer meth, double elco[], double tesco[]);
  extern void d02nmx(Integer neq, double y[], double *yh, Integer nyh, double ewt[],
                     double ydot[], double savr[], double acor[], Integer *inln, 
                     Integer *istep, double *el0, double *h, double *tn, double *hmin,
                     double *hmxi, double rdae[], double rworkx[], Integer *irevcm,
                     Nag_ODE_BDF *intern_comm);
  extern void d02nnm(Integer inln);
  extern void d02nnn(double x[], Integer n, Integer imsg, Nag_ODE_BDF *intern_comm);
  extern void d02nnw(Integer neq, double *t, double tout, double *h0, double y[],
                     double ydoti[], double ewt[], double rtol[], double a_tol[], 
                     Integer itol, Nag_ODE_BDF *intern_comm);
  extern void d02nnx(Integer *n, Integer itol, double rtol[], double a_tol[], 
                     double ycur[], double ewt[], Integer *iewset, 
                     Nag_ODE_BDF *intern_comm);
  extern NAG_DLL_EXPIMP void NAG_CALL d02nsc(Integer neq, Integer neqmax, char *jceval, Integer nwkjac, 
                                             double rwork[], Integer *ifail);
  extern NAG_DLL_EXPIMP void NAG_CALL d02nvc(Integer neqmax, Integer ny2dim, Integer maxord, char *method, 
                                             Boolean petzld, double const_[], double tcrit, double hmin, 
                                             double hmax, double h0, Integer maxstp, Integer mxhnil, 
                                             char *norm, double rwork[], Integer *ifail);
  extern void d02nvz(Integer neqmax, Integer ny2dim, Integer maxord, Integer *meth,
                     Boolean petzld, double const_[], double tcrit, double hmin,
                     double hmax, double h0, Integer maxstp, Integer mxhnil, 
                     char *norm, double rwork[], Integer *ierr, Boolean *report);
  extern NAG_DLL_EXPIMP void NAG_CALL d02pcc(Integer neq, 
                                             NAG_D02PCC_FUN f,
                                             double twant, double *tgot,
                                             double ygot[], double ypgot[], double ymax[],
                                             Nag_ODE_RK *opt, Nag_User *comm, NagError * fail);
  extern NAG_DLL_EXPIMP void NAG_CALL d02pdc(Integer neq,
                                             NAG_D02PCC_FUN f,
                                             double *tnow, double ynow[],
                                             double ypnow[], Nag_ODE_RK *opt, Nag_User *comm,
                                             NagError *fail);
  extern void d02pdm(Boolean ask, const char *srname, Integer * state, Nag_ODE_RK *opt);
  extern void d02pdp(Integer *ier, const char *srname, Integer *ifail, Nag_ODE_RK *opt);
  extern double d02pdq(double u[], double v[], double wt[], Integer neq);
  extern void d02pdr(double v1v1, double v0v1, double v0v0,
                     double *rold, double *rho, double root1[],
                     double root2[], Boolean * rootre);
  extern void d02pds(double alpha, double beta, double r1[],
                     double r2[]);
  extern void d02pdt(Integer neq, double v[], double havg, double x,
                     double y[], NAG_D02PCC_FUN f,
                     double fxy[], double wt[],
                     double scale, double vdotv, double z[],
                     double *zdotz, double vtemp[], Nag_ad02pd *ad02pd_1,
                     Nag_bd02pd *bd02pd_1, Nag_User *comm);
  extern void d02pdu(Integer neq,
                     NAG_D02PCC_FUN f,
                     double x, double y[],
                     double hnow, double havg, double xend,
                     Integer maxfcn, double wt[], double fxy[],
                     double v0[], Boolean * unsure, Boolean * stif, double v1[],
                     double v2[], double v3[], double vtemp[], Nag_ODE_RK *opt,
                     Nag_User *comm);
  extern void d02pdv(Integer neq, 
                     NAG_D02PCC_FUN f,
                     double havg, Integer * jflstp,
                     Boolean toomch, Integer maxfcn, double work[],
                     Integer * ier, Nag_ODE_RK *opt, Nag_User *comm,
                     char buf[]);
  extern void d02pdw(
                     NAG_D02PCC_FUN f,
                     Integer neq, double y[], double tol,
                     double weight[], double zy[], double zyp[],
                     double zerror[], double zynew[], double zerres[],
                     double zstage[], Integer * ier, Nag_ODE_RK *opt, Nag_User *comm);
  extern void d02pdx(Integer neq, double y[], double yp[], double h,
                     double ynew[], double stages[], double thres[],
                     double *err, Boolean main, double weight[], Nag_dd02pd *dd02pd_1);
  extern void d02pdy(double tnow, double y[], double yp[],
                     double tstg, double ystg[], double ypstg[],
                     double *htry, double weight[], Boolean * cutbak, 
                     Nag_ODE_RK *opt);
  extern void d02pdz(
                     NAG_D02PCC_FUN f,
                     Integer neq, double tnow, double y[],
                     double yp[], double stages[], double tol,
                     double *htry, double weight[], double ynew[],
                     double errest[], double *err, Boolean main,
                     double hmin, double thres[], Boolean * phase2,
                     Nag_ODE_RK *opt, Nag_User *comm);
  extern NAG_DLL_EXPIMP void NAG_CALL d02ppc(Nag_ODE_RK *opt);
  extern NAG_DLL_EXPIMP void NAG_CALL d02pvc(Integer neq, double tstart, double ystart[],
                                             double tend, double tol, double thres[],
                                             Nag_RK_method method, Nag_RK_task task, Nag_ErrorAssess errass,
                                             double hstart, Nag_ODE_RK *opt, NagError * fail);
  extern void d02pvx(double *mcheps, double *dwarf);
  extern void d02pvy(Nag_gd02pd *gd02pd_1);
  extern void d02pvz(Integer method, Integer * vecstg, Boolean * reqstg,
                     Integer * lintpl, Nag_dd02pd *dd02pd_1, Nag_ed02pd *ed02pd_1,
                     Nag_gd02pd *gd02pd_1);
  extern NAG_DLL_EXPIMP void NAG_CALL d02pwc(double tend_new, Nag_ODE_RK *opt, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL d02pxc(Integer neq, double twant, Nag_SolDeriv reqest, Integer nwant,
                                             double ywant[], double ypwant[],
                                             NAG_D02PDC_FUN f,
                                             Nag_ODE_RK *opt, Nag_User *comm, NagError *fail);
  extern void d02pxy(
                     NAG_D02PDC_FUN f,
                     Integer neq, Integer nwant, double y[],
                     double yp[], double yold[], double ypold[],
                     double stages[], Boolean calstg, double xstage[],
                     double ytemp[],
                     double p[], Nag_ad02pd *ad02pd_1, Nag_bd02pd *bd02pd_1,
                     Nag_dd02pd *dd02pd_1, Nag_User *comm);
  extern void d02pxz(double y[], double yp[], double p[],
                     double twant, char reqest, Integer nwant,
                     double ywant[], double ypwant[],
                     Nag_bd02pd *bd02pd_1, Nag_dd02pd *dd02pd_1);
  extern NAG_DLL_EXPIMP void NAG_CALL d02pyc(Integer *totfcn, Integer * stpcst, double *waste,
                                             Integer *stpsok, double *hnext, Nag_ODE_RK *opt);
  extern NAG_DLL_EXPIMP void NAG_CALL d02pzc(Integer neq, double rmserr[], double *errmax, double *terrmx,
                                             Nag_ODE_RK *opt, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL d02qfc(Integer neqf, 
                                             NAG_D02QFC_FUN fcn,
                                             double *t, double y[], double tout,
                                             NAG_D02QFC_GFUN g,
                                             Nag_User *comm, Nag_ODE_Adams *opt, NagError *fail);
  //Cheney 2006-6-5 add typedef for pointer to function
  /*extern void d02qfg(Boolean *ret,
                     int *irevcm, double *twant, Integer *kwant, double gwant,
                     Integer neq, double *t, double y[], double ypout[],
                     double x, double yy[], double r[], double r2d[], 
                     NAG_D02QFG_FUN rintrp,
                     Integer neqg, double gold[],
                     double gnew[], double tgv[], double gv[], double tkt[],
                     double tlbmr[], double trbmr[], double proot[],
                     double rootd[], Integer mmreq[], Integer indxg[],
                     Integer igsc[], Integer needgk[],
                     Integer *kroot, Integer *inroot,
                     Nag_ad02 *ad02qf, Nag_bd02 *bd02qf,
                     Nag_dd02 *dd02qf, Nag_ed02 *ed02qf,
                     Nag_fd02 *fd02qf, Nag_gd02 *gd02qf);*/
  extern void d02qfg(Boolean *ret,
                     int *irevcm, double *twant, Integer *kwant, double gwant,
                     Integer neq, double *t, double y[], double ypout[],
                     double x, double yy[], double r[], double r2d[], 
                     NAG_D02QFG_FUN rintrp,
                     Integer neqg, double gold[],
                     double gnew[], double tgv[], double gv[], double tkt[],
                     double tlbmr[], double trbmr[], double proot[],
                     double rootd[], Integer mmreq[], Integer indxg[],
                     Integer igsc[], Integer needgk[],
                     Integer *kroot, Integer *inroot,
                     Nag_ad02 *ad02qf, Nag_bd02 *bd02qf,
                     Nag_dd02 *dd02qf, Nag_ed02 *ed02qf,
                     Nag_fd02 *fd02qf, Nag_gd02 *gd02qf);
  extern double d02qfn(double v[], Integer ncomp);
  extern void d02qfp(int *irevcm, Integer neq, double *twant,
                     double b, double y[], double yprime[],
                     double etol[], Integer morder, double small1,
                     double big, double spy[], double pv[], double yp[],
                     double sf[], double *h, Nag_ODE_Adams *opt);
  extern void d02qfq(int *irevcm, double *twant, Integer neqn,
                     double y[], double *x, double *h, double *eps,
                     double wt[], Boolean *start, double *hold,
                     Integer *k, Integer *kold, Boolean *crash, double phi[],
                     double p[], double yp[], double psi[], double alpha[],
                     double beta[], double sig[], double v[], double w[],
                     double g[], Boolean *phase1, Integer *ns, Boolean *nornd,
                     Integer *ksteps, double twou, double fouru,
                     double *xold, Integer *kprev, Integer *ivc, Integer iv[],
                     Integer *kgi, double gi[], Integer *nsucc, Integer *nfail,
                     Nag_ODE_Adams *opt);
  extern void d02qfr(double x, double y[], double xout,
                     double yout[], double ypout[], Integer nint,
                     Integer neqn, Integer kold, double phi[], Integer ivc,
                     Integer iv[], Integer kgi, double gi[], double alpha[],
                     double og[], double ow[], double ox,
                     double oy[]);
  extern void d02qfs(double t, double yint[], double ypint[],
                     Integer neq, double x, double yy[], double p[],
                     double phi[], Nag_ad02 *ad02qf_1);
  extern void d02qft(double *a, double *fa, double *b, double *fb,
                     double rez, double aez, Integer *iflag, Nag_dd02 *dd02qf_1);
  extern void d02qfu(int *irevcm, Integer *k, double gwant,
                     Integer neqg, Integer *kroot, Integer *inroot,
                     double gold[], double proot[], double rootd[],
                     double gp[], Integer igsc[], double tout,
                     Nag_ODE_Adams *opt, Nag_bd02 *bd02qf_1);
  //Cheney 2006-6-5 add typedef for pointer to function
  /*extern void d02qfv(int *irevcm, double *twant, Integer *kwant, double gwant,
                     Integer neq, double *t, double y[], double ypout[],
                     double tout, double x, double yy[], double r[], double r2d[],
                     NAG_D02QFV_FUN rintrp,
                     Integer neqg, double gold[], double gnew[],
                     double gp[], double tgv[], double gv[], double tkt[],
                     double tlbmr[], double trbmr[], double proot[],
                     double rootd[], Integer mmreq[], Integer indxg[],
                     Integer igsc[], Integer needgk[], Integer *kroot,
                     Integer *inroot, Integer *izflag, Nag_ODE_Adams *opt,
                     Nag_ad02 *ad02qf, Nag_bd02 *bd02qf);*/
  extern void d02qfv(int *irevcm, double *twant, Integer *kwant, double gwant,
                     Integer neq, double *t, double y[], double ypout[],
                     double tout, double x, double yy[], double r[], double r2d[],
                     NAG_D02QFV_FUN rintrp,
                     Integer neqg, double gold[], double gnew[],
                     double gp[], double tgv[], double gv[], double tkt[],
                     double tlbmr[], double trbmr[], double proot[],
                     double rootd[], Integer mmreq[], Integer indxg[],
                     Integer igsc[], Integer needgk[], Integer *kroot,
                     Integer *inroot, Integer *izflag, Nag_ODE_Adams *opt,
                     Nag_ad02 *ad02qf, Nag_bd02 *bd02qf);
  extern void d02qfw(Integer neqg, Integer *kroot, Integer *inroot,
                     double tkt[], double gold[], double proot[],
                     double rootd[], double gp[], Integer needgk[],
                     Integer igsc[], double t, Nag_bd02 *bd02qf_1);
  extern void d02qfx(int *irevcm, double *twant, Integer *kwant,
                     double gwant, Integer neq, double *t,
                     double y[], double tout, double rtol[],
                     double a_tol[], Integer *idid, double ypout[],
                     double yp[], double yy[], double wt[], double p[],
                     double phi[], double gold[], double gnew[],
                     double tgv[], double gv[], double gp[], double tkt[],
                     double tlbmr[], double trbmr[], double proot[],
                     double rootd[], double tstop, double *h,
                     double *eps, double *x, double hmax,
                     Integer maxnum, Integer *nsucc, Integer *nfail, Integer indxg[],
                     Integer igsc[], Integer mmreq[], Integer needgk[], Integer *kroot,
                     Integer *inroot, Integer neqg, Integer *badcmp, Nag_ODE_Adams *opt,
                     Nag_ad02 *ad02qf_1, Nag_bd02 *bd02qf_1);
  extern NAG_DLL_EXPIMP void NAG_CALL d02qwc(Nag_Start *state, Integer neqf, Boolean vectol, double a_tol[],
                                             double rtol[], Boolean onestp, Boolean crit, double tcrit,
                                             double hmax, Integer maxstp, Integer neqg, Boolean *alterg,
                                             Boolean sophst, Nag_ODE_Adams *opt, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL d02qyc(Nag_ODE_Adams *opt);
  extern NAG_DLL_EXPIMP void NAG_CALL d02qzc(Integer neqf, double twant, Integer nwant,
                                             double ywant[], double ypwant[], Nag_ODE_Adams *opt,
                                             NagError *fail);
  extern void d02qzz(double t, double yint[], double ypint[],
                     Integer nint, Integer neq, double x, double yy[],
                     double p[], double phi[], Nag_ad02 *ad02qf_1);
  extern NAG_DLL_EXPIMP void NAG_CALL d02rac(Integer neq, double *deleps,
                                             NAG_D02RAC_FUN fcn,
                                             Integer numbeg, Integer nummix,
                                             NAG_D02RAC_GFUN g,
                                             Nag_MeshSet init, Integer mnp, Integer * np, double x[],
                                             double y[], 
                                             double tol, double abt[],
                                             NAG_D02RAC_JFUN jacobf,
                                             NAG_D02RAC_JGFUN jacobg,            
                                             NAG_D02RAC_JEPSFUN jaceps,
                                             NAG_D02RAC_JGEPSFUN jacgep,
                                             Nag_User *comm,
                                             NagError * fail);
  extern void d02rar (Integer m, Integer n, 
                      Integer irn[], Integer nirn, Integer ip[], Integer nip, 
                      double h[], double x[], double f[],
                      double hmax[], double umin, double uaim,
                      double umax, double *eps, double *eps1,
                      Boolean * adjust,
                      double a[], 
                      Integer ig[], Integer nig,
                      double w[], 
                      Integer nw, 
                      double z[], 
                      Integer * ind,
                      Integer * ifail,
                      Nag_ad02ra *ad02ra);
  extern void d02ras(double a[], double c[], double del[], double y[],
                     Integer m, Integer * n, Integer p, Integer r, Integer ir[],
                     Integer ic[], double u[], Integer * mtnmax, Integer nmax,
                     double x[], Boolean * sing);
  extern void d02rat(double a[], double c[], double del[], Integer m,
                     Integer * n, Integer p, Integer r, Integer ir[],
                     Integer ic[], Boolean * sing, Integer ica[], double aux[],
                     Integer * mtnmax, Integer nmax, Integer * mmax2);
  extern void d02rau(Integer neq, Integer * np, Integer p, Integer r,
                     double x[], double y[], Integer iy,
                   
                     NAG_D02RAZ_fcn fcn,
                     NAG_D02RAZ_g g,
                     NAG_D02RAZ_fcnep fcnep,
                     NAG_D02RAZ_jacobg jacobg,
                     NAG_D02RAZ_jacobe jacobe,            
                     double b20[], 
                     NAG_D02RAZ_fcna fcna,
                   
                     double a1[], double b1[],
                     double a[], double c[],
                     double del[],
                     Boolean * casi, Boolean * sing, 
                     Integer ir[], Integer ic[],
                     double uu[], double res[],
                     Integer * lin,
                     Integer * mtnmax, Integer nmax, Integer * mmax2, 
                     double hx[],
                     double gradf[], double aux[], 
                     Integer ica[],
                     double xau[],
                     double *epsnu, 
                     double hmax[],
                     Integer ig[], 
                     Integer nig,
                     double h[],
                     Integer irn[],
                     Integer ip1[],
                     Integer nip, 
                     double f[], double alpha[],
                     Integer * iflag, Integer lp,
                     Nag_User *comm,
                     Nag_ad02ra *ad02ra);
  extern void d02rav(Integer neq, Integer * np, Integer p, Integer r,
                     double alpha[], double a1[], double b1[], double x[],
                     double y[], Integer iy, double a2[], double c2[],
                     double del[], 
                     NAG_D02RAZ_fcn fcn,
                     NAG_D02RAZ_g g,
                     NAG_D02RAZ_fcnep fcnep,
                     NAG_D02RAZ_fcna fcna,
                     NAG_D02RAZ_fcnb fcnb,
                     NAG_D02RAZ_jacobe jacobe,
                     NAG_D02RAZ_jacobg jacobg,
                     double a10[], double b10[],
                     double gam[], double a20[], double b20[],
                     Integer * jerror, double *eps, Integer ir[], Integer ic[],
                     double uu[], double res[], Integer * mtnmax, Integer nmax,
                     Integer * mmax2, double f[], double hx[], double sk[],
                     double gradf[], double aux[], Integer ica[],
                     double xau[], Integer lp, Integer mp, Integer * lin,
                     double *epsnu, Integer * nu, Integer * inwt, Boolean * casi,
                     double hmax[], Integer ig[], Integer nig, double h[],
                     Integer irn[], Integer ip[], Integer nip, Nag_User *comm, Nag_ad02ra *ad02ra);
  extern void d02raw(Integer * i0, Integer * n, Integer * np, double c[],
                     double bb[], double x[], Integer nmax,
                     double xbar, double alf[]);
  extern void d02rax(Integer k, Integer p, Integer q, Integer n, Integer m,
                     double a[], double x[], Integer nmax, double y[],
                     double s[], Integer * mtnmax, double alf[],
                     double c[], Integer * ierror);
  extern void d02ray(Integer neq, Integer nmax, Integer * n, Integer p, Integer r,
                     Integer * mtnmax, Integer * mmax2,
                     double *a, double *b, double tol,
                     double x[], double y[],
                     Integer iy,
                     double abt[],
                     NAG_D02RAZ_fcn fcn,
                     NAG_D02RAZ_g g,
                     NAG_D02RAZ_fcnep fcnep,
                     NAG_D02RAZ_fcna fcna,
                     NAG_D02RAZ_fcnb fcnb,
                     NAG_D02RAZ_jacobe jacobe,
                     NAG_D02RAZ_jacobg jacobg,
                     NAG_D02RAZ_jaceps jaceps,
                     NAG_D02RAZ_jacgep jacgep,
                     double a10[], double b10[], double gam[],
                     double a20[], double b20[], double alpha[],
                     double a1[], double b1[], double ej[], double a2[],
                     double c2[], double del[], double uu[], double res[],
                     double f[], double hx[], double sk[], double gradf[],
                     double aux[], double xau[], 
                     Integer ic[], Integer ir[], Integer iqj[], Integer ica[],
                     double *deleps, Integer lp,
                     Integer mp, Integer init, Integer * lin,
                     double h2[], double hmax[], 
                     Integer ig[], 
                     Integer nig,
                     Integer ip2[],
                     Integer nip,
                     Integer irn[], Integer * iflag,
                     Nag_User *comm,
                     Nag_ad02ra *ad02ra);
  extern void d02raz(Integer neq, Integer nmax, Integer * np, Integer numbeg,
                     Integer nummix, double *a, double *b, double tol,
                     double x[], double y[], Integer iy, double abt[],
                     NAG_D02RAZ_fcn fcn,
                     NAG_D02RAZ_g g,
                     NAG_D02RAZ_fcnep fcnep,
                     NAG_D02RAZ_fcna fcna,
                     NAG_D02RAZ_fcnb fcnb,
                     NAG_D02RAZ_jacobe jacobe,
                     NAG_D02RAZ_jacobg jacobg,
                     NAG_D02RAZ_jaceps jaceps,
                     NAG_D02RAZ_jacgep jacgep,
                     double a1[], double b1[],
                     double c1[], double d1[], double gam[], double a2[],
                     double b2[], double work[], Integer * lwork, Integer * iwork,
                     Integer liwork, double *deleps, Integer lp, Integer mp,
                     Integer init, Integer * lin, Integer * iflag, Nag_User *comm, Nag_ad02ra *ad02ra);
  extern void d02xjy(double t, Integer k, double *yh, Integer nyh, double dky[], 
                     Integer *iflag, Integer neq, double *h, double *tn, double *hu,
                     Integer *nq, double *odcode, Nag_ODE_BDF *intern_comm);
  extern void d02xjz(double t, Integer k, double *yh, Integer nyh, double dky[],
                     Integer *iflag, Integer neq, double *h, double *tn, double *hu,
                     Integer *nq, Nag_ODE_BDF *intern_comm);
  extern NAG_DLL_EXPIMP void NAG_CALL d02xkc(double xsol, double sol[], Integer m, double *w, Integer neqmax,
                                             Integer iw, double w2[], Integer neq, double x, Integer nq,
                                             double hu, double h, Integer *ifail, Nag_ODE_BDF *intern_comm);
  extern void d02xkz(double t, Integer k, double *yh, Integer nyh, double dky[], 
                     Integer *iflag, Integer neq, double acor[], double h, double tn,
                     double hu, Integer nq, Nag_ODE_BDF *intern_comm);
  extern NAG_DLL_EXPIMP double NAG_CALL d02zac(Integer n, double v[], double w[], Integer *ifail,
                                               Nag_ODE_BDF *intern_comm);
  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGD02 */
